/**
* \file: mlink_wl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK GST Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2015 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
* 0.2 Bodo Winter Add functions to connect and disconnect audio devices.
*
***********************************************************************/

#ifndef _MLINK_GST_H_
#define _MLINK_GST_H_

#ifdef __cplusplus
extern "C"
{
#endif

#define VNC_USE_STDINT_H

#include "mlink_common.h"
#include <gst/gst.h>
#include <gst/rtp/gstrtpbuffer.h>

typedef struct mlink_rtp_out_context mlink_rtp_out_context;
typedef struct mlink_rtp_in_context mlink_rtp_in_context;

typedef void mlink_gst_rtp_out_data_callback(void * p_user_ctx,
        guint32 * extension, guint16 extension_size, guint8 markerbit);

typedef void mlink_gst_rtp_out_error_callback(void * p_user_ctx,
        mlink_rtp_out_context * p_rtp_out_ctx, char * pMessage);

typedef void mlink_gst_rtp_in_error_callback(void * p_user_ctx,
        mlink_rtp_in_context * p_rtp_in_ctx, char * pMessage);

typedef void mlink_gst_streaming_thread_callback(void * p_user_ctx, gchar * name);


void mlink_gst_init(int *argc, char **argv[]);

mlink_rtp_out_context * mlink_gst_start_rtp_out_streaming (const char * url,
        char * playback_device, unsigned int payloadtype, unsigned int ipl,
        mlink_gst_rtp_out_error_callback * error_cb,
        mlink_gst_rtp_out_data_callback * data_cb,
        mlink_gst_streaming_thread_callback * streaming_thread_cb,
        void * p_user_ctx, DltContext * p_dlt_ctx);

void mlink_gst_stop_rtp_out_streaming (mlink_rtp_out_context * p_ctx);

mlink_rtp_in_context * mlink_gst_start_rtp_in_streaming (const char * url,
        char * capture_device, unsigned int payloadtype,
        mlink_gst_rtp_in_error_callback * error_cb,
        mlink_gst_streaming_thread_callback * streaming_thread_cb,
        void * p_user_ctx, DltContext * p_dlt_ctx);

void mlink_gst_stop_rtp_in_streaming (mlink_rtp_in_context * p_ctx);


typedef enum {
    MLINK_GST_RAMP_NONE,
    MLINK_GST_RAMP_LINEAR,
    MLINK_GST_RAMP_CUBIC
} mlink_gst_ramp_type;

void mlink_gst_disconnect_audio_device (mlink_rtp_out_context * p_ctx,
        guint32 fade_out_ms, mlink_gst_ramp_type ramp_type);

void mlink_gst_connect_audio_device (mlink_rtp_out_context * p_ctx,
        gchar * device_name, guint32 fade_in_ms, mlink_gst_ramp_type ramp_type);

#ifdef __cplusplus
}
#endif

#endif /* _MLINK_GST_H_ */
